REM COUNT3.BAT  Standard Header File, Version 1.00    Microchip Technology, Inc.
echo off
REM 
REM ********************************************************
REM * Demo program for command line PRO MATE
REM *   This program downloads a device file then repeatedly
REM *   programs the device based on argument supplied by user.
REM *   This file accepts command line arguments as inputs.
REM *   This program will query user for all possible inputs.
REM *   An out of environment space error means the user must
REM *   increase the space available to the DOS environment.
REM *   Single argument specifies devices to be programmed.
REM ********************************************************
REM
REM        1. Command line switch:
REM               COUNT3 %1
REM               %1 - Number of devices to program
REM
REM        2. Requirements
REM               DOS 6.0 or higher
REM
REM        3. Note : "out of environment space" requires user to
REM           allocate a larger environment with the following
REM                   command.com  /e:4096 (or more)
REM
REM
REM==========================================================================
REM
REM       Revision History
REM
REM==========================================================================
REM
REM     Rev:   Date:    Reason:
REM
REM     1.00   05/01/97 Initial Release
@echo off

cls
REM*********************************************************************
REM*********************** Query section *******************************
echo off

:comport
cls
answer "Enter com port /q-quit "
if %answer%==/q goto userbreak
if "%answer%"=="" goto nan
set line1=%answer%
set line2=%answer%

:devicetype
cls
answer "Enter device type /q-quit "
if %answer%==/q goto userbreak
if "%answer%"=="" goto nan
set line1=/p%answer% /%line1%
set line2=/p%answer% /%line2%


:downloadfile
cls
answer "Enter download file /q-quit "
if %answer%==/q goto userbreak
if "%answer%"=="" goto nan
set line1=/f%answer% %line1%


:sqtpfile
cls
answer "Enter sqtpfile /q-quit "
if %answer%==/q goto userbreak
if "%answer%"=="" goto vpp
set line2=/s%answer% %line2%

:vpp
cls
answer "Enter vpp mV /q-quit "
if %answer%==/q goto userbreak
if "%answer%"=="" goto vddmax
set line2=/v%answer% %line2%

:vddmax
cls
answer "Enter vdd max mV /q-quit "
if %answer%==/q goto userbreak
if "%answer%"=="" goto vddmin
set line2=/x%answer% %line2%

:vddmin
cls
answer "Enter vdd min mV /q-quit "
if %answer%==/q goto userbreak
if "%answer%"=="" goto qmode
set line2=/n%answer% %line2%

:qmode
cls
answer "Would you like quiet mode? y/n /q-quit "
if %answer%==/q goto userbreak
if "%answer%"=="Y" goto qmodedo
if "%answer%"=="y" goto qmodedo
if "%answer%"=="N" goto safemode
if "%answer%"=="n" goto safemode
goto qmode
:qmodedo
set line2=/q %line2%

:safemode
cls
answer "Would you like safe mode? y/n /q-quit "
if %answer%==/q goto userbreak
if "%answer%"=="Y" goto safemoddo
if "%answer%"=="y" goto safemoddo
if "%answer%"=="N" goto prog
if "%answer%"=="n" goto prog
goto safemode
:safemoddo
set line2=/r %line2%
goto prog

:nan
echo off
cls
echo You must specify a valid value for this argument
goto comport



REM ************************************************************************
REM ******************** programming section *******************************


if "%1"=="?" goto error1
:prog
set answer=




REM ***initial programmer
procmd %line1%
set line1=
if NOT ERRORLEVEL 1 goto initc

goto error2



:do

cls
echo PLEASE STRIKE ANY KEY WHEN NEW DEVICE %count% IS READY FOR PROGRAMMING
choice continue?
if ERRORLEVEL 2 goto end

cls
echo PROGRAMMING DEVICE %count% of %1
echo off

REM ***program device 
procmd %line2% /M
echo %count%
if NOT ERRORLEVEL 1 goto incr_1
goto error2






REM ********************************************************************
REM ********************* Counting Section *****************************/
:initc
REM Use this file as a basis for counting functions
REM COUNT.BAT accepts variable %1 as the number of times to loop

REM Initialize Place Holder Variables
 set d1=0
 set d2=0
 set d3=0
 set d4=0
goto incr_1

REM Start the incrementing process
:incr
 if %count% == %1 goto end
 if %d1%%d2%%d3 == 000 goto 1digit
 if %d1%%d2%    == 00  goto 2digit
 if %d1%        == 0   goto 3digit
 set count=%d1%%d2%%d3%%d4%
 goto do

:1digit
 set count=%d4%
 goto do

:2digit
 set count=%d3%%d4%
 goto do

:3digit
 set count=%d2%%d3%%d4%
 goto do

REM Functions,programs, etc. to be looped %1 number of times
REM Increment the 1s digit.  When it reaches ten, move on the 10s
REM increment
:incr_1
 if %d4% == 9 goto incr_10
 if %d4% == 8 set d4=9
 if %d4% == 7 set d4=8
 if %d4% == 6 set d4=7
 if %d4% == 5 set d4=6
 if %d4% == 4 set d4=5
 if %d4% == 3 set d4=4
 if %d4% == 2 set d4=3
 if %d4% == 1 set d4=2
 if %d4% == 0 set d4=1
 goto incr

REM Reset 1s digit. Increment the 10s digit. When it reaches 100, move on
REM to 100s increment
:incr_10
 set d4=0
 if %d3% == 9 goto incr_100
 if %d3% == 8 set d3=9
 if %d3% == 7 set d3=8
 if %d3% == 6 set d3=7
 if %d3% == 5 set d3=6
 if %d3% == 4 set d3=5
 if %d3% == 3 set d3=4
 if %d3% == 2 set d3=3
 if %d3% == 1 set d3=2
 if %d3% == 0 set d3=1
 goto incr

REM Reset 10s digit. Increment the 100s digit.  When it reaches 1000, let
RE, the user know the counter is beyond capacity
:incr_100
 set d3=0
 if %d2% == 9 goto incr_n
 if %d2% == 8 set d2=9
 if %d2% == 7 set d2=8
 if %d2% == 6 set d2=7
 if %d2% == 5 set d2=6
 if %d2% == 4 set d2=5
 if %d2% == 3 set d2=4
 if %d2% == 2 set d2=3
 if %d2% == 1 set d2=2
 if %d2% == 0 set d2=1
 goto incr


REM Reset 100 digit. Increment the 1000s digit.  When it reaches 10000, let
REM the user know the counter is beyond capacity
:incr_n
 set d2=0
 if %d1% == 9 goto :incr_outofrange
 if %d1% == 8 set d1=9
 if %d1% == 7 set d1=8
 if %d1% == 6 set d1=7
 if %d1% == 5 set d1=6
 if %d1% == 4 set d1=5
 if %d1% == 3 set d1=4
 if %d1% == 2 set d1=3
 if %d1% == 1 set d1=2
 if %d1% == 0 set d1=1
 goto incr


REM ************************************************************************
REM *********************** Exit Section ***********************************


:error2
    if errorlevel 32 goto error
    if errorlevel 31 if not errorlevel 32 goto labe31
    if errorlevel 30 if not errorlevel 31 goto labe30
    if errorlevel 29 if not errorlevel 30 goto labe29
    if errorlevel 28 if not errorlevel 29 goto labe28
    if errorlevel 27 if not errorlevel 28 goto labe27
    if errorlevel 26 if not errorlevel 27 goto labe26
    if errorlevel 25 if not errorlevel 26 goto labe25
    if errorlevel 24 if not errorlevel 25 goto labe24
    if errorlevel 23 if not errorlevel 24 goto labe23
    if errorlevel 22 if not errorlevel 23 goto labe22
    if errorlevel 21 if not errorlevel 22 goto labe21
    if errorlevel 20 if not errorlevel 21 goto labe20
    if errorlevel 19 if not errorlevel 20 goto label9
    if errorlevel 18 if not errorlevel 19 goto label8
    if errorlevel 17 if not errorlevel 18 goto label7
    if errorlevel 16 if not errorlevel 17 goto label6
    if errorlevel 15 if not errorlevel 16 goto label5
    if errorlevel 14 if not errorlevel 15 goto label4
    if errorlevel 13 if not errorlevel 14 goto label3
    if errorlevel 12 if not errorlevel 13 goto label2
    if errorlevel 11 if not errorlevel 12 goto label1
    if errorlevel 10 if not errorlevel 11 goto label0
    if errorlevel 9 if not errorlevel 10 goto label9
    if errorlevel 8 if not errorlevel 9 goto label8
    if errorlevel 7 if not errorlevel 8 goto label7
    if errorlevel 6 if not errorlevel 7 goto label6
    if errorlevel 5 if not errorlevel 6 goto label5
    if errorlevel 4 if not errorlevel 5 goto label4
    if errorlevel 3 if not errorlevel 4 goto label3
    if errorlevel 2 if not errorlevel 3 goto label2
    if errorlevel 1 if not errorlevel 2 goto label1

:label1
echo PRO MATE not found              Could not establish communication
echo                                 with PRO MATE.
echo                                 Possible causes are:
echo                                 1.)  PRO MATE serial cable not
echo                                      attached
echo                                 2.)  PRO MATE not powered up
echo                                 3.)  PRO MATE not connected to
echo                                      the selected communications
echo                                      port.
goto end

:label2
echo            The selected device is not
echo            supported by the socket module
echo            currently installed in PRO MATE.
goto end

:label3
echo            A specific firmware, program
echo            memory, or SQTP file was not
echo            found.
goto end

:label4
echo            The specified device is either
echo            not supported by PRO MATE or is
echo            not supported by the command
echo            line interface to PRO MATE.
echo            HCS devices and Smart Serial
echo            EEPROMs are not supported by the
echo            command line interface.
goto end

:label5
echo            A specified voltage is outside
echo            of the valid range for the
echo            selected device, Vdd Max is less
echo            than Vdd Min, or a specified
echo            voltage is not an even multiple
echo            of 125mV( for 125 mV steps).
goto end

:label6
echo            An unspecified error was found
echo            while programming the device.
echo            Usually, a specific error
echo            informing the user what area
echo            of memory failed will be returned.
goto end

:label7
echo            Downloading firmware cannot be
echo            combined with any other operation
echo            other than selecting the
echo            communications port, which is
echo            required.
goto end

:label8
echo            An invalid command line parameter
echo            was encountered.

:label9
echo            An invalid hex record record was
echo            found, or the file is not in
echo            valid INHX8M or INHX32 format.
goto end

:label10
echo            An invalid record was found in
echo            the SQTP file, or the file is not
echo            a file in the INHX8M format.
goto end

:label11
echo            No command line parameters were
echo            found.
goto end
                

:label12
echo            The desired communications port
echo            must be specified with the
echo            /# option.
goto end
                                  

:label13
echo            The selected communications port
echo            could not be found or initialized.
goto end
                                       

:label14
echo            Unless downloading firmware,
echo            the target device must be specifed
echo            with the /p option.
goto end

:label15
echo            The file MPLAB.DVS must be located
echo            in the same directory as the PRO
echo            MATE command line interface
echo            executable.  This file is installed
echo            with the PRO MATE installation.
goto end

:label16
echo            There was not enough memory
echo            available on the PC to allocate
echo            buffers for the device's memory.
goto end

:label17
echo            The device file that was located
echo            is of an incompatible version.
echo            Reinstall the application.
goto end

:label18
echo            The version of firmware currently
echo            in the PRO MATE Device Programmer
echo            is not compatible with the
echo            software.  Download the version
echo            of firmware that was installed
echo            with the software, or obtain the
goto end
 
:label19
echo            The version of firmware currently
echo            in the PRO MATE Device Programmer
echo            does not support the selected
echo            device.  Download the version of
echo            firmware that was installed with
echo            the software, or obtain the latest
echo            version from the Microchip BBS
echo            or web site.
goto end

:label20         
echo            An error occured while
echo            communicating with the PRO MATE
echo            Device Programmer.  Verify that
echo            the Device Programmer is powered
echo            on and all serial connections are
echo            firm.
goto end

:label21
echo            The selected device is not
echo            supported by the command line
echo            version.  These devices must be
echo            programmed by the full interface
echo            version.  Examples of these
echo            devices are the security devices
echo            and smart serials.
goto end

:label22
echo             There are no available SQTP
echo             numbers in the specified file.
goto end

:label23
echo             The SQTP line just read cannot be
echo             marked as used. Be sure the file
echo             is not read only.
goto end

:label24
echo             A programming or verification
echo             error occurred when programming
echo             the device's program memory.
goto end

:label25
echo             A programming or verification
echo             error occurred when programming 
echo             the device's data memory.
goto end

:label26
echo             A programming or verification
echo             error occurred when programming
echo             the device's configuration bits.
goto end

:label27
echo             A programming or verification
echo             error occurred when programming
echo             the device's IDs.
goto end

:label28
echo             A parity error occurred during
echo             programming or verifying.  This
echo             often occurs when overprogramming
echo             a parity device.  If using a
echo             windowed device, erase  the device
echo             and reprogram.
goto end

:label29
echo             If the help screen is shown, no
echo             other commands are processed.
goto end

:label30
echo             A command line parameter requiring
echo             a file specification did not
echo             specify a file.
goto end

:label31
echo             This error should never be seen.
echo             It can occur as a result of
echo             erroneous communication between
echo             the device programmer and the PC.
goto end

goto end





:error1
echo count2 - program arguments
echo count arg#1
echo arg#1 number of eproms to program valid range 1- 9999
echo                     1997 Microchip Technology, Inc.
goto end

:userbreak
cls
echo Program terminated by user
goto end

REM Let user know the file has looped beyond it's capacity
:incr_outofrange
 echo Count has gone beyond 9999!


REM Continue normal batch execution at this point
:end
 set d1=
 set d2=
 set d3=
 set d4=
 set count=
 set line1=
 set line2=


